IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_ETL_Full_Insert_Group_Icon_Association]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_ETL_Full_Insert_Group_Icon_Association]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[usp_ETL_Full_Insert_Group_Icon_Association]
@END_DATE DATETIME, @SOURCE_DB NVARCHAR(250)
AS
BEGIN
SET NOCOUNT ON;

BEGIN TRY

	DECLARE @SQL VARCHAR(max), @FROM_CLAUSE NVARCHAR(MAX), @INDEX INT, @ROWS INT, @START_DATE DATETIME
	
	--DROP TABLE GROUP_ICON_ASSOCIATION_ETL
	IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GROUP_ICON_ASSOCIATION_ETL]'))
	BEGIN
		DROP TABLE GROUP_ICON_ASSOCIATION_ETL
	END
	
	--DISABLE INDEXES
	SET @SQL = ''
	SELECT @SQL =@SQL + 'ALTER INDEX ' + ind.name + ' ON  ' + obj.name + ' DISABLE;' +CHAR(13)+CHAR(10)
	FROM 
		sys.indexes as ind
	JOIN 
		sys.objects  as obj
		ON ind.object_id = obj.object_id
	WHERE  ind.type_desc = 'NONCLUSTERED' and obj.name = 'GROUP_ICON_ASSOCIATION';	
	EXEC (@SQL)
	
	SET @START_DATE = '1900-01-01'
	SET @INDEX = CHARINDEX('.', @SOURCE_DB)		
	
	IF @INDEX = 0
		SET @FROM_CLAUSE = @SOURCE_DB + '.[dbo].[ufn_ETL_Group_Icon_Association](''' + CONVERT(NVARCHAR(50),@START_DATE,109) + ''', ''' + CONVERT(NVARCHAR(50),@END_DATE,109) + ''')'
	ELSE
		SET @FROM_CLAUSE = 'OPENQUERY( ' + SUBSTRING(@SOURCE_DB, 0, @INDEX) + ', ''SELECT * FROM ' + SUBSTRING(@SOURCE_DB, @INDEX + 1, LEN(@SOURCE_DB)) + 
					'.[dbo].[ufn_ETL_Group_Icon_Association](''''' + CONVERT(NVARCHAR(50),@START_DATE,109) + ''''', ''''' + CONVERT(NVARCHAR(50),@END_DATE,109) + ''''') '')'
		
	SET @SQL = ''
	SET @SQL = @SQL + '
		SELECT  [BED_SOURCE_ID],
				 [PATIENT_SOURCE_ID],
				 [ICON_FLAG_ID],
				 [ICON_FLAG_FACILITY_ID],
				 [SOURCE_ID],
				 [_ssis_timestamp]
		INTO GROUP_ICON_ASSOCIATION_ETL
		FROM ' + @FROM_CLAUSE
	EXEC (@SQL)
	
	SET @ROWS = @@ROWCOUNT
	
	--ADDED INDEXES ON TABLE GROUP_ICON_ASSOCIATION_ETL
	IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GROUP_ICON_ASSOCIATION_ETL]'))
	BEGIN
			CREATE NONCLUSTERED INDEX [idx_BED_SOURCE_ID] ON GROUP_ICON_ASSOCIATION_ETL(BED_SOURCE_ID ASC)
			CREATE NONCLUSTERED INDEX [idx_PATIENT_SOURCE_ID] ON GROUP_ICON_ASSOCIATION_ETL(PATIENT_SOURCE_ID ASC)
			CREATE NONCLUSTERED INDEX [idx_ICON_FLAG_ID] ON GROUP_ICON_ASSOCIATION_ETL(ICON_FLAG_ID ASC)
			CREATE NONCLUSTERED INDEX [idx_ICON_FLAG_FACILITY_ID] ON GROUP_ICON_ASSOCIATION_ETL(ICON_FLAG_FACILITY_ID ASC)
			CREATE NONCLUSTERED INDEX [idx_SOURCE_ID] ON GROUP_ICON_ASSOCIATION_ETL(SOURCE_ID ASC)

			INSERT INTO GROUP_ICON_ASSOCIATION
				   ([DIM_BED_ID]
				   ,[DIM_PATIENT_ID]
				   ,[DIM_ICON_FLAG_ID]
				   ,[DIM_ICON_FLAG_FACILITY_ID]
				   ,[SOURCE_ID]
				   ,[_SSIS_TIMESTAMP])
			SELECT  db.ID,
					dPatient.ID,
					dif.ID,
					difFac.ID,
					GROUP_ICON.SOURCE_ID,
					GROUP_ICON.[_ssis_timestamp]
			FROM GROUP_ICON_ASSOCIATION_ETL AS GROUP_ICON 
					LEFT JOIN DIM_BED db on GROUP_ICON.BED_SOURCE_ID = db.SOURCE_ID
					LEFT JOIN DIM_PATIENT dPatient on GROUP_ICON.PATIENT_SOURCE_ID = dPatient.SOURCE_ID
					LEFT JOIN [DIM_ICON_FLAG] dif ON dif.source_id = GROUP_ICON.ICON_FLAG_ID
					LEFT JOIN [DIM_ICON_FLAG_FACILITY] difFac ON difFac.source_id = GROUP_ICON.ICON_FLAG_FACILITY_ID
	END
	
	--REBUILD INDEXES ON TABLE GROUP_ICON_ASSOCIATION
	SET @SQL = ''
	SELECT @SQL =@SQL + 'ALTER INDEX ' + ind.name + ' ON  ' + obj.name + ' REBUILD;' +CHAR(13)+CHAR(10)
	FROM 
		sys.indexes as ind
	JOIN 
		sys.objects  as obj
		ON ind.object_id = obj.object_id
	WHERE  ind.type_desc = 'NONCLUSTERED' and obj.name = 'GROUP_ICON_ASSOCIATION';
	EXEC (@SQL)
	
	--TRUNCATE TABLE GROUP_ICON_ASSOCIATION_ETL
	IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GROUP_ICON_ASSOCIATION_ETL]'))
	BEGIN
			TRUNCATE TABLE GROUP_ICON_ASSOCIATION_ETL
	END
	
	RETURN @ROWS

END TRY
BEGIN CATCH
	
	DECLARE @ErrorMessage NVARCHAR(4000), @ErrorSeverity INT, @ErrorState INT;
			
	SELECT @ErrorMessage = '*** ERROR in usp_ETL_Full_Insert_Group_Icon_Association: ' + ERROR_MESSAGE(),
		   @ErrorSeverity = ERROR_SEVERITY(),
		   @ErrorState = ERROR_STATE();
	
	RAISERROR (@ErrorMessage,  @ErrorSeverity, @ErrorState) WITH LOG;

	--ENABLED INDEX
	SET @SQL = ''
	SELECT @SQL =@SQL + 'ALTER INDEX ' + ind.name + ' ON  ' + obj.name + ' REBUILD;' +CHAR(13)+CHAR(10)
	FROM 
		sys.indexes as ind
	JOIN 
		sys.objects  as obj
		ON ind.object_id = obj.object_id
	WHERE  ind.type_desc = 'NONCLUSTERED' and obj.name = 'GROUP_ICON_ASSOCIATION';
	EXEC (@SQL)

END CATCH	

END

GO


